/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.python.indexer.Def;
import org.python.indexer.Indexer;
import org.python.indexer.NBinding;
import org.python.indexer.Ref;
import org.python.indexer.Util;
import org.python.indexer.ast.NName;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NUrl;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scope {
    private static Set<Scope> looked = new HashSet<Scope>();
    private Map<String, NBinding> table;
    private Scope parent;
    private List<Scope> supers;
    private Set<String> globalNames;
    private Type scopeType;
    private String path = "";
    private int lambdaCounter = 0;
    private boolean isBindingPhase = false;

    public Scope(Scope scope, Type type) {
        if (type == null) {
            throw new IllegalArgumentException("'type' param cannot be null");
        }
        this.setParent(scope);
        this.setScopeType(type);
    }

    public void setTable(Map<String, NBinding> map) {
        this.table = map;
    }

    public Map<String, NBinding> getTable() {
        if (this.table != null) {
            return Collections.unmodifiableMap(this.table);
        }
        Map<String, NBinding> map = Collections.emptyMap();
        return map;
    }

    public void setParent(Scope scope) {
        this.parent = scope;
    }

    public Scope getParent() {
        return this.parent;
    }

    public void addSuper(Scope scope) {
        if (this.supers == null) {
            this.supers = new ArrayList<Scope>();
        }
        this.supers.add(scope);
    }

    public void setSupers(List<Scope> list) {
        this.supers = list;
    }

    public List<Scope> getSupers() {
        if (this.supers != null) {
            return Collections.unmodifiableList(this.supers);
        }
        List<Scope> list = Collections.emptyList();
        return list;
    }

    public void setScopeType(Type type) {
        this.scopeType = type;
    }

    public Type getScopeType() {
        return this.scopeType;
    }

    public boolean isFunctionScope() {
        return this.scopeType == Type.FUNCTION;
    }

    public void addGlobalName(String string) {
        if (string == null) {
            return;
        }
        if (this.globalNames == null) {
            this.globalNames = new HashSet<String>();
        }
        this.globalNames.add(string);
    }

    public boolean isGlobalName(String string) {
        if (this.globalNames != null) {
            return this.globalNames.contains(string);
        }
        return this.parent == null ? false : this.parent.isGlobalName(string);
    }

    public void put(String string, NBinding nBinding) {
        this.putBinding(string, nBinding);
    }

    public NBinding put(String string, NNode nNode, NType nType, NBinding.Kind kind) {
        if (nType == null) {
            throw new IllegalArgumentException("Null type: id=" + string + ", loc=" + nNode);
        }
        NBinding nBinding = this.lookupScope(string);
        return this.insertOrUpdate(nBinding, string, nNode, nType, kind);
    }

    public NBinding putAttr(String string, NNode nNode, NType nType, NBinding.Kind kind) {
        if (nType == null) {
            throw new IllegalArgumentException("Null type: id=" + string + ", loc=" + nNode);
        }
        if ("".equals(this.path)) {
            Indexer.idx.reportFailedAssertion("Attempting to set attr '" + string + "' at location " + nNode + (nNode != null ? nNode.getFile() : "") + " in scope with no path (qname) set: " + this.toShortString());
            return null;
        }
        NBinding nBinding = this.lookupAttr(string);
        return this.insertOrUpdate(nBinding, string, nNode, nType, kind);
    }

    private NBinding insertOrUpdate(NBinding nBinding, String string, NNode nNode, NType nType, NBinding.Kind kind) {
        if (nBinding == null) {
            nBinding = this.insertBinding(new NBinding(string, nNode, nType, kind));
        } else {
            this.updateType(nBinding, nNode, nType, kind);
        }
        return nBinding;
    }

    public NBinding update(String string, NNode nNode, NType nType, NBinding.Kind kind) {
        if (nType == null) {
            throw new IllegalArgumentException("Null type: id=" + string + ", loc=" + nNode);
        }
        return this.update(string, new Def(nNode), nType, kind);
    }

    public NBinding update(String string, Def def, NType nType, NBinding.Kind kind) {
        if (nType == null) {
            throw new IllegalArgumentException("Null type: id=" + string + ", loc=" + def);
        }
        NBinding nBinding = this.lookupScope(string);
        if (nBinding == null) {
            return this.insertBinding(new NBinding(string, def, nType, kind));
        }
        nBinding.getDefs().clear();
        nBinding.addDef(def);
        nBinding.setType(nType);
        if (nBinding.getType().isUnknownType()) {
            nBinding.setKind(kind);
        }
        return nBinding;
    }

    private NBinding insertBinding(NBinding nBinding) {
        switch (nBinding.getKind()) {
            case MODULE: {
                nBinding.setQname(nBinding.getType().getTable().path);
                break;
            }
            case PARAMETER: {
                nBinding.setQname(this.extendPathForParam(nBinding.getName()));
                break;
            }
            default: {
                nBinding.setQname(this.extendPath(nBinding.getName()));
            }
        }
        nBinding = Indexer.idx.putBinding(nBinding);
        this.putBinding(nBinding.getName(), nBinding);
        return nBinding;
    }

    private void putBinding(String string, NBinding nBinding) {
        this.ensureTable();
        this.table.put(string, nBinding);
    }

    private void updateType(NBinding nBinding, NNode nNode, NType nType, NBinding.Kind kind) {
        NType nType2;
        NType nType3;
        NType nType4;
        NType nType5 = nBinding.followType();
        if (!this.isNewType(nType5, nType)) {
            if (nNode != null && !(nNode instanceof NUrl) && !nBinding.getDefs().contains(nNode)) {
                Indexer.idx.putLocation(nNode, nBinding);
            }
            return;
        }
        if (nNode != null && !nBinding.getRefs().contains(nNode)) {
            nBinding.addDef(nNode);
            nBinding.setProvisional(false);
        }
        if ((nType4 = nBinding.getType()).isUnknownType() && !nType4.getTable().isEmpty()) {
            nType3 = nType;
            nType2 = nType4;
        } else {
            nType3 = nType4;
            nType2 = nType;
        }
        NType nType6 = NUnionType.union(nType3, nType2);
        nBinding.setType(nType6);
        if (nType5.isUnknownType()) {
            nBinding.setKind(kind);
        }
        this.retargetReferences(nBinding, nType5);
    }

    private void retargetReferences(NBinding nBinding, NType nType) {
        Scope scope = nBinding.followType().getTable();
        for (Map.Entry<String, NBinding> entry : nType.getTable().entrySet()) {
            String string = entry.getKey();
            NBinding nBinding2 = entry.getValue();
            if (!nBinding2.isProvisional()) continue;
            Indexer.idx.removeBinding(nBinding2);
            NBinding nBinding3 = scope.lookupAttr(string);
            if (nBinding3 == null) continue;
            ArrayList<Ref> arrayList = new ArrayList<Ref>();
            arrayList.addAll(nBinding2.getRefs());
            for (Ref ref : arrayList) {
                Indexer.idx.updateLocation(ref, nBinding3);
            }
        }
    }

    private boolean isNewType(NType nType, NType nType2) {
        if (this.isBindingPhase) {
            return false;
        }
        if (nType.isUnionType()) {
            return !nType.asUnionType().contains(nType2);
        }
        return nType != nType2;
    }

    public void remove(String string) {
        if (this.table != null) {
            this.table.remove(string);
        }
    }

    public Scope copy(Type type) {
        Scope scope = new Scope(null, type);
        if (this.table != null) {
            scope.ensureTable();
            scope.table.putAll(this.table);
        }
        return scope;
    }

    public void setPath(String string) {
        if (string == null) {
            throw new IllegalArgumentException("'path' param cannot be null");
        }
        this.path = string;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String string, String string2) {
        NBinding nBinding = this.lookup(string);
        NBinding nBinding2 = this.lookup(string2);
        if (nBinding != null && nBinding2 != null) {
            nBinding.setQname(nBinding2.getQname());
        }
    }

    public NBinding lookup(String string) {
        NBinding nBinding;
        NBinding nBinding2 = this.getModuleBindingIfGlobal(string);
        if (nBinding2 != null) {
            return nBinding2;
        }
        if (this.table != null && (nBinding = this.table.get(string)) != null) {
            return nBinding;
        }
        if (this.getParent() == null) {
            return null;
        }
        return this.getParent().lookup(string);
    }

    public NBinding lookup(NNode nNode) {
        if (nNode instanceof NName) {
            return this.lookup(((NName)nNode).id);
        }
        return null;
    }

    public NBinding lookupLocal(String string) {
        NBinding nBinding = this.getModuleBindingIfGlobal(string);
        if (nBinding != null) {
            return nBinding;
        }
        return this.table == null ? null : this.table.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NBinding lookupAttr(String string, boolean bl) {
        Object object;
        if (looked.contains(this)) {
            return null;
        }
        if (this.table != null && !bl && (object = this.table.get(string)) != null) {
            return object;
        }
        if (this.supers == null || this.supers.isEmpty()) {
            return null;
        }
        looked.add(this);
        try {
            for (Scope scope : this.supers) {
                NBinding nBinding = scope.lookupAttr(string);
                if (nBinding == null) continue;
                NBinding nBinding2 = nBinding;
                return nBinding2;
            }
            object = null;
            return object;
        }
        finally {
            looked.remove(this);
        }
    }

    public NBinding lookupAttr(String string) {
        return this.lookupAttr(string, false);
    }

    public NType lookupType(String string) {
        return this.lookupType(string, false);
    }

    public NType lookupType(String string, boolean bl) {
        NBinding nBinding;
        NBinding nBinding2 = nBinding = bl ? this.lookupLocal(string) : this.lookup(string);
        if (nBinding == null) {
            return null;
        }
        NType nType = nBinding.followType();
        if (this == Indexer.idx.moduleTable) {
            if (nType.isModuleType()) {
                return nType;
            }
            if (nType.isUnionType()) {
                for (NType nType2 : nType.asUnionType().getTypes()) {
                    NType nType3 = nType2.follow();
                    if (!nType3.isModuleType()) continue;
                    return nType3;
                }
            }
            Indexer.idx.warn("Found non-module type in module table: " + nBinding);
            return null;
        }
        return nType;
    }

    public NType lookupTypeAttr(String string) {
        NBinding nBinding = this.lookupAttr(string);
        if (nBinding != null) {
            return nBinding.followType();
        }
        return null;
    }

    public NBinding lookupBounded(String string, Type type) {
        if (this.scopeType == type) {
            return this.table == null ? null : this.table.get(string);
        }
        if (this.getParent() == null) {
            return null;
        }
        return this.getParent().lookupBounded(string, type);
    }

    public boolean isScope() {
        switch (this.scopeType) {
            case CLASS: 
            case INSTANCE: 
            case FUNCTION: 
            case MODULE: 
            case GLOBAL: {
                return true;
            }
        }
        return false;
    }

    public Scope getScopeSymtab() {
        if (this.isScope()) {
            return this;
        }
        if (this.getParent() == null) {
            Indexer.idx.reportFailedAssertion("No binding scope found for " + this.toShortString());
            return this;
        }
        return this.getParent().getScopeSymtab();
    }

    public NBinding lookupScope(String string) {
        NBinding nBinding = this.getModuleBindingIfGlobal(string);
        if (nBinding != null) {
            return nBinding;
        }
        Scope scope = this.getScopeSymtab();
        if (scope != null) {
            return scope.lookupLocal(string);
        }
        return null;
    }

    public Scope getSymtabOfType(Type type) {
        if (this.scopeType == type) {
            return this;
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.getSymtabOfType(type);
    }

    public Scope getGlobalTable() {
        Scope scope = this.getSymtabOfType(Type.MODULE);
        if (scope == null) {
            Indexer.idx.reportFailedAssertion("No module table found for " + this);
            scope = this;
        }
        return scope;
    }

    public Scope getEnclosingLexicalScope() {
        if (this.scopeType == Type.FUNCTION || this.scopeType == Type.MODULE) {
            return this;
        }
        if (this.parent == null) {
            Indexer.idx.reportFailedAssertion("No lexical scope found for " + this);
            return this;
        }
        return this.parent.getEnclosingLexicalScope();
    }

    private NBinding getModuleBindingIfGlobal(String string) {
        Scope scope;
        if (this.isGlobalName(string) && (scope = this.getGlobalTable()) != null && scope != this) {
            return scope.lookupLocal(string);
        }
        return null;
    }

    public boolean isNameBindingPhase() {
        return this.isBindingPhase;
    }

    public void setNameBindingPhase(boolean bl) {
        this.isBindingPhase = bl;
    }

    public void merge(Scope scope) {
        this.ensureTable();
        this.table.putAll(scope.table);
    }

    public Set<String> keySet() {
        if (this.table != null) {
            return this.table.keySet();
        }
        Set<String> set = Collections.emptySet();
        return set;
    }

    public Collection<NBinding> values() {
        if (this.table != null) {
            return this.table.values();
        }
        Set<NBinding> set = Collections.emptySet();
        return set;
    }

    public Set<Map.Entry<String, NBinding>> entrySet() {
        if (this.table != null) {
            return this.table.entrySet();
        }
        Set<Map.Entry<String, NBinding>> set = Collections.emptySet();
        return set;
    }

    public boolean isEmpty() {
        return this.table == null ? true : this.table.isEmpty();
    }

    public void clear() {
        if (this.table != null) {
            this.table.clear();
            this.table = null;
        }
        this.parent = null;
        if (this.supers != null) {
            this.supers.clear();
            this.supers = null;
        }
        if (this.globalNames != null) {
            this.globalNames.clear();
            this.globalNames = null;
        }
    }

    public String newLambdaName() {
        return "lambda%" + ++this.lambdaCounter;
    }

    public String extendPathForParam(String string) {
        if (this.path.equals("")) {
            throw new IllegalStateException("Not inside a function");
        }
        return this.path + "@" + string;
    }

    public String extendPath(String string) {
        if (string.endsWith(".py")) {
            string = Util.moduleNameFor(string);
        }
        if (this.path.equals("")) {
            return string;
        }
        String string2 = null;
        switch (this.scopeType) {
            case CLASS: 
            case INSTANCE: 
            case MODULE: 
            case SCOPE: {
                string2 = ".";
                break;
            }
            case FUNCTION: {
                string2 = "&";
                break;
            }
            default: {
                System.err.println("unsupported context for extendPath: " + (Object)((Object)this.scopeType));
                return this.path;
            }
        }
        return this.path + string2 + string;
    }

    private void ensureTable() {
        if (this.table == null) {
            this.table = new LinkedHashMap<String, NBinding>();
        }
    }

    public String toString() {
        return "<Scope:" + (Object)((Object)this.getScopeType()) + ":" + this.path + ":" + (this.table == null ? "{}" : this.table.keySet()) + ">";
    }

    public String toShortString() {
        return "<Scope:" + (Object)((Object)this.getScopeType()) + ":" + this.path + ">";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        CLASS,
        INSTANCE,
        FUNCTION,
        MODULE,
        GLOBAL,
        SCOPE;

    }
}

